(************************************************************************
 *                                                                      *
 *   Ant Movie Catalog 4.x                                              *
 *   (C) 2000-2006 Antoine Potten                                       *
 *   http://www.antp.be/software                                        *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit getscript_picktree;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls,

  AntCorelButton, base, ExtCtrls, AntAutoHintLabel;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

type
  TPickTreeWin = class(TBaseDlg)
    TreeView1: TTreeView;
    btnView: TCorelButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure TreeView1DblClick(Sender: TObject);
    procedure btnViewClick(Sender: TObject);
  private
    FAddresses: TStringList;
    FLastRoot: TTreeNode;
    FMoreLink: string;
  protected
    procedure LoadOptions; override;
    procedure SaveOptions; override;
  public
    procedure Clear;
    procedure Add(const Caption, Address: string);
    procedure SetMoreLink(const Address: string);
    function Execute(out Address: string): Boolean;
    procedure Sort;
  end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

var
  PickTreeWin: TPickTreeWin;

implementation

uses
  Global, functions_files;

{$R *.dfm}

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.Add(const Caption, Address: string);
begin
  with TreeView1.Items do
    if Address = '' then
    begin
      FLastRoot := Add(nil, Caption);
      FLastRoot.Data := Pointer(0);
    end else
      AddChild(FLastRoot, Caption).Data := Pointer(FAddresses.Add(Address)+1);
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.Clear;
begin
  FLastRoot := nil;
  FAddresses.Clear;
  TreeView1.Items.Clear;
  SetMoreLink('');
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function TPickTreeWin.Execute(out Address: string): Boolean;
var
  i: Integer;
begin
  Result := False;
  Address := '';
  if TreeView1.Items.Count = 0 then
    MessageWin.Execute('No movie found', mtWarning, [mbOk])
  else
  begin
    btn3.Enabled := False;
    with TreeView1.Items do
    begin
      for i := 0 to Count-1 do
        Item[i].Expand(True);
      Item[0].Selected := True;
      Item[0].MakeVisible;
    end;
    case ShowModal of
      mrOk:
        begin
          if (TreeView1.Selected <> nil) and (Integer(TreeView1.Selected.Data) > 0) then
            Address := FAddresses.Strings[Integer(TreeView1.Selected.Data)-1];
          Result := True;
        end;
      mrRetry:
        begin
          Address := FMoreLink;
          Result := True;
        end;
    end;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.FormCreate(Sender: TObject);
begin
  FAddresses := TStringList.Create;
  FLastRoot := nil;
  SetMoreLink('');
  inherited;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.FormDestroy(Sender: TObject);
begin
  FAddresses.Free;
  inherited;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.SetMoreLink(const Address: string);
begin
  FMoreLink := Address;
  btn2.Enabled := Address <> '';
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.TreeView1Change(Sender: TObject; Node: TTreeNode);
begin
  with TreeView1 do
    btn3.Enabled := (Selected <> nil) and (Integer(Selected.Data) > 0);
  btnView.Enabled := btn3.Enabled;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.TreeView1DblClick(Sender: TObject);
begin
  if btn3.Enabled then
    btn3.Click;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.btnViewClick(Sender: TObject);
begin
  if (TreeView1.Selected <> nil) and (Integer(TreeView1.Selected.Data) > 0) then
    LaunchProg(FAddresses.Strings[Integer(TreeView1.Selected.Data)-1]);
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.Sort;
begin
  TreeView1.AlphaSort(True);
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.LoadOptions;
begin
  with Settings.rScripts.rPickTree do
  begin
    Width := WindowWidth;
    Height := WindowHeight;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TPickTreeWin.SaveOptions;
begin
  with Settings.rScripts.rPickTree do
  begin
    WindowWidth := Width;
    WindowHeight := Height;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

end.
